unit uDB;

{
   Package: TIU - TEXT INTEGRATION UTILITIES 
   Date Created: Oct 23, 2006
   Site Name: xxxxxxxxxxxxxxxx
   Developers: zzzzzzzzzuser, SGT
   Description: Mobile Electronic Documentation 
   Note: This unit requires XWB*1.1 and TIU*1*244 in order to run. 
         Includes Template routines from CPRS
}

interface

uses Forms,ComObj, Dialogs, SysUtils, uNote,classes,ORFn,comctrls,
      { TODO -oherb -c2007 : Adding variants for vartab }
      variants, Windows;

  function DBConnect(MDB:string;out con:OleVariant):boolean;
  function ExecuteQuery(con:OleVariant;query:string):boolean;
  function Nz(fld:OleVariant;default:string):string;
  function SQLSafe(clean:string):string;
  
  { TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//  function GetNotes(con:OleVariant;PatientDFN:integer):OleVariant;
  function GetNotes(con:OleVariant;PatientDFN: INT64 ):OleVariant;

  { TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//  function GetNotesArr(con:OleVariant;PatientDFN:integer):TNoteRecordArr;
  function GetNotesArr(con:OleVariant;PatientDFN: INT64 ):TNoteRecordArr;

  
  function GetCount(con:OleVariant;TableQuery:string;Where:string):integer;
  procedure GetNoteID(con:OleVariant;ntNote:TNoteRecord);
  function DBClose(con:OleVariant):boolean;

  { TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//  function GetPatient(con:OleVariant;WithDFN:Integer;WithName, WithDOB, WithSSN:String;WithUserAccess:Integer):Integer;
  function GetPatient(con:OleVariant; WithDFN: INT64 ; WithName, WithDOB, WithSSN:String;WithUserAccess:Integer): INT64 ;
    
  function TrimNonNumeric(TrimStr:string):String;

implementation

type
  //Class created to fix an issue with CPRS v26 with global scoped OleVariant database connection.
  TDBConn = class(TObject)
    public
      con : OleVariant;
    end;


procedure GetNoteID(con:OleVariant;ntNote:TNoteRecord);
var
  rst:OleVariant;
begin
  try
    //Have a note?
      if not assigned(ntNote) then
        Exit;
        
    //Have a connection?
      if not VarType(con) = VarDispatch then
        Exit;

    //Connected?
      if not (con.state = 1) then
        Exit;

    //Query our recordset
      { TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//      rst := con.Execute('SELECT MAX(ntRfnbr) as NoteID FROM [Notes] WHERE ntPatnbr = ' + IntToStr(ntNote.ParentDFN) + ' AND ntNoteTitle = ''' + SQLSafe(ntNote.Title) + ''' and ntCaption = ''' + SQLSafe(ntNote.Caption) + '''',EmptyParam,0);
      rst := con.Execute('SELECT MAX(ntRfnbr) as NoteID FROM [Notes] WHERE ntPatnbr = "' + IntToStr(ntNote.ParentDFN) + '" AND ntNoteTitle = ''' + SQLSafe(ntNote.Title) + ''' and ntCaption = ''' + SQLSafe(ntNote.Caption) + '''',EmptyParam,0);

    //Have any?
      if not VarType(rst) = VarDispatch then
        exit;

      if rst.EOF and rst.BOF then
        Exit;

    //Get the value
      ntNote.NoteID := rst.Fields['NoteID'];

  except on E:Exception do
    begin
      { TODO -oHerb -c508 : TODO -oHerb -c508 : Replace ShowMessage with MessageBox - Matt Greener said JAWS could not read the text }
//      ShowMessage('GetNoteID Error:' + E.Message);
      MessageBox(0, PChar('GetNoteID Error:' + E.Message), 'Error', MB_OK);
    end;

  end;
end;

function TrimNonNumeric(TrimStr:string):String;
var
  i:integer;
  strRet:String;
begin
  //Default
    strRet := '';
  //Look for valid chars
    for i:= 1 to Length(TrimStr) do
      begin
        if (TrimStr[i] in ['0'..'9']) then strRet := strRet + TrimStr[i];
      end;
  //Yes
    Result := strRet;
end;

{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function GetPatient(con:OleVariant;WithDFN:Integer;WithName, WithDOB, WithSSN:String; WithUserAccess:Integer):Integer;
function GetPatient(con:OleVariant; WithDFN : INT64; WithName, WithDOB, WithSSN:String; WithUserAccess:Integer): INT64;
var
  rstMatch:OleVariant;
  strCPRSName,strDBName,strF,strL,strCF, strCL:String;
  dtCPRSDOB,dtDOB:TDateTime;
  wCYear,wCDay,wCMonth,wDYear,wDDay,wDMonth:Word;
begin
  //Default
  Result := WithDFN;

  //Matching by ssn?
  try
    //Query
    rstMatch := con.Execute('SELECT ptDFN, ptName, ptDOB From [Patients] WHERE Trim(ptSSN) = Trim(''' + TrimNonNumeric(WithSSN) + ''')');
  except on E:Exception do
    begin
      { TODO -oHerb -c508 : TODO -oHerb -c508 : Replace ShowMessage with MessageBox - Matt Greener said JAWS could not read the text }
//      ShowMessage('GetPatient Error:' + E.Message);
      MessageBox(0, PChar('GetPatient Error:' + E.Message), 'Error', MB_OK);
    end;
  end;

  //Have any?
    if not VarType(rstMatch) = VarDispatch then
      exit;

  //Anything?
  if rstMatch.EOF and rstMatch.BOF then
    Exit;

  //Are we only requiring matching the SSN?
  case WithUserAccess of
    1:
      begin
        //Copy and format
        try
          //Databaase
            //Name
              strDBName := LowerCase(Nz(rstMatch.Fields['ptName'],''));
              strF := Copy(Piece(strDBName,',',1),1,1);
              strL := Copy(Piece(strDBName,',',2),1,1);
            //DOB
              dtDOB := StrToDateTime(Nz(rstMatch.Fields['ptDOB'],'1/1/1701'));
              DecodeDate(dtDOB,wDYear,wDMonth,wDDay);
          //Passed
            //Name
              strCPRSName := LowerCase(WithName);
              strCF := Copy(Piece(strCPRSName,',',1),1,1);
              strCL := Copy(Piece(strCPRSName,',',2),1,1);
            //DOB
              dtCPRSDOB := StrToDateTime(WithDOB);
              DecodeDate(dtCPRSDOB,wCyear,wCMonth,wCDay);
          //Do we match?
            //Name components
              if strF <> strCF then Exit;
              if strL <> strCL then Exit;
            //DOB Components
              if wCYear <> wDYear then Exit;
              if wCMonth <> wDMonth then Exit;
              if wCDay <> wDDay then Exit;
          //Match.  Return the new ID
            Result := StrToInt(Nz(rstMatch.Fields['ptDFN'],'0'));
        except on E:Exception do
          begin
            { TODO -oHerb -c508 : TODO -oHerb -c508 : Replace ShowMessage with MessageBox - Matt Greener said JAWS could not read the text }
//            ShowMessage('Error Comparing:' + E.Message);
            MessageBox(0, PChar('Error Comparing:' + E.Message), 'Error', MB_OK);
            Exit;
          end;
        end;

      end;
    2:
      begin
        //This match is enough (e.g. they are allowed to match just on SSN)
{ TODO -oherb -cInvalid Integer : 
Still having invalid integer issues.  Changing integer to INt64 to fix
the problem.  12/17/2009 }
//        Result := StrToInt(Nz(rstMatch.Fields['ptDFN'],'0'));
        Result := StrToInt64(Nz(rstMatch.Fields['ptDFN'],'0'));
      end;
  end;


end;



function ExecuteQuery(con:OleVariant;query:string):boolean;
begin
  try
    con.Execute(query);
    Result := True;   //Query succeeded
  except
    Result := False;  //Query failed
  end;
end;

{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function GetNotesArr(con:OleVariant;PatientDFN:integer):TNoteRecordArr;
function GetNotesArr(con:OleVariant;PatientDFN:INT64):TNoteRecordArr;
var
  rstNt:OleVariant;
  arRec:TNoteRecordArr;
  rcNew:TNoteRecord;
  i:integer;
begin
  //Default return
    Result := nil;
  //Get the records
    rstNt := GetNotes(con,PatientDFN);
  //Add our items
    if not (VarType(rstNt) = VarDispatch) then
      Exit;
  //Get our items
    while(rstNt.EOF = False) do
      begin
        //Create our record
          rcNew := TNoteRecord.Create();

        //Populate it
          if rcNew.SetNoteData(rstNt) = True then
            begin
              //Get the length
                if(not assigned(arRec)) then
                  i := 0
                else
                  i := Length(arRec);

              //Now resize our array and add the record item
                SetLength(arRec,i+1);
                arRec[i] := rcNew;
          end;

        //Next record
          rstNt.MoveNext;
      end;

  //Return our array
    Result := arRec;
end;

{ TODO -oHerb -cIntToINT64 : 
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//function GetNotes(con:OleVariant;PatientDFN:integer):OleVariant;
function GetNotes(con:OleVariant;PatientDFN: INT64 ):OleVariant;
var
  rst:OleVariant;
begin
  //Default value of nil
    Result := VarNull;
  //Have a connection?
    if not VarType(con) = VarDispatch then
      Exit;

  //Connected?
    if not (con.state = 1) then
      Exit;

  //Query our recordset
    { TODO -oHerb -cIntToINT64 :
Changing Integer to INT64 to accommodate the large dfn Andrew
was using - 12 char long. }
//    rst := con.Execute('SELECT ntRfnbr, ntPatNbr, ntNoteTitle, ntCaption, ntNote, ntImported FROM Notes WHERE ntPatNbr = ' + IntToStr(PatientDFN) + ' Order by ntImported, ntCreateDate',EmptyParam,0);
{ TODO -oherb -cModification : Change for version 4 to 4a Order the notes in Descending order. }
//    rst := con.Execute('SELECT ntRfnbr, ntPatNbr, ntNoteTitle, ntCaption, ntNote, ntImported FROM Notes WHERE ntPatNbr = "' + IntToStr(PatientDFN) + '" Order by ntImported, ntCreateDate',EmptyParam,0);
    rst := con.Execute('SELECT ntRfnbr, ntPatNbr, ntNoteTitle, ntCaption, ntNote, ntImported FROM Notes WHERE ntPatNbr = "' + IntToStr(PatientDFN) + '" Order by ntImported, ntCreateDate DESC ',EmptyParam,0);

    Result:= rst;

  //Have any?
    if not VarType(rst) = VarDispatch then
      Result := VarNull;

    if rst.EOF and rst.BOF then
      Result := VarNull;
end;

function DBConnect(MDB:string;out con:OleVariant):boolean;
begin
  //Default
    Result := False;

  //Have a connection object
    if not (VarType(con) = VarDispatch) then
      begin
        con := CreateOleObject('ADODB.Connection');
        //Still missing?
          if not (VarType(con) = VarDispatch) then
            Exit;
      end;

  //Connect
    con.Open('Provider=Microsoft.Jet.OLEDB.4.0; Data Source=' + MDB + ';','','',0);

  //Return connection status
    Result := (con.State = 1);
end;

//Similar to Access's Nz function to return a value for a null
function Nz(fld:OleVariant;default:string):string;
  begin
    try
      if VarType(fld.value) = varNull then
        Result := default    //Null.. return the default
      else
        Result := fld.value;     //Return the value itself
    except
      Result:=default;
    end;
  end;

//Quote strings for sql commands
function SQLSafe(clean:string):string;
  begin
    //Replace each instance of ' with ''
      Result := StringReplace(clean,'''','''''',[rfReplaceAll]);
  end;

//Find notes older than the specified number of days
function DeleteDaysOldNotes(con:OleVariant;NumDays:integer):boolean;
var
  dtFrom:TDateTime;
  dtDay:TDateTime;
  strQry:string;
begin
  //Calculate the date that is x number of days from today.
    //Calculate a day
      dtDay := EncodeDate(2000,01, 02) - EncodeDate(2000,01, 01);
    //Current date minus the number of days
      dtFrom := Date() - (dtDay * NumDays);
    //Create the query
      strQry := 'DELETE from Notes where ntCreateDate < #' + DateToStr(dtFrom) + '# and ntImported = TRUE';
    //Execute the query
      Result := ExecuteQuery(con,strQry);
end;

function GetCount(con:OleVariant;TableQuery:string;Where:string):integer;
var
  rstCnt:OleVariant;
begin
  rstCnt := con.Execute('SELECT Count(*) as Cnt FROM ' + TableQuery + ' WHERE ' + Where);
  if not VarType(rstCnt) = VarDispatch then
    Result := -1
  else
    begin
      if rstCnt.EOF and rstCnt.BOF then
        Result := -1
      else
        Result := rstCnt.Fields['Cnt'];
    end;
end;

function DBClose(con:OleVariant):boolean;
begin
  try
    if VarType(con) = VarDispatch then
      con.Close;
    Result := True;
  except
    Result := False;
  end;
end;

end.

